import { StyleSheet, View } from 'react-native';
import React, { useState } from 'react';
import FilterComponent from '../FilterComponent/FilterComponent';
import SearchProducts from '../Filters/SearchProducts';
import ListView from '../SearchFilter2/ListView';
import dpr from '../../Utilities/CustomStyleAttribute/dpr';

const SearchFilter1 = ({
    searchContent,
    setFilterModal,
    sortByRef,
    sortBy,
    sortByArray,
}) => {
    const [listView, setListView] = useState(false);
    return (
        <View style={searchFilterStyle.cont}>
            <FilterComponent
                setListView={setListView}
                listView={listView}
                setFilterModal={setFilterModal}
                sortByRef={sortByRef}
                sortBy={sortBy}
                sortByArray={sortByArray}
            />
            {listView ? (
                <ListView searchContent={searchContent} />
            ) : (
                <SearchProducts searchContent={searchContent} />
            )}
        </View>
    );
};

export default SearchFilter1;

const searchFilterStyle = StyleSheet.create({
    cont: { paddingBottom: dpr(140) },
});
